function orbit_plotter

load gravity

%Plot orbits
figure('name','verlet gravity sim','color',[1 1 1]);
plot(x,y);
xlabel('x /AU','fontsize',fsize);
ylabel('y /AU','fontsize',fsize);
title(['Gravity simulator using Verlet method: ',num2str(Nm),' masses'],'fontsize',fsize);
set(gca,'fontsize',fsize)
grid on;
axis equal
xlim(xlimits);
ylim(ylimits);
print( gcf, 'gravity.png','-dpng','-r300' );

%Animate orbits
cla;
p = plot( x(1,3:end).',y(1,3:end).','.','markersize',msize );
hold on;
p1 = plot( x(1,1),y(1,1),'r.','markersize',msize );
p2 = plot( x(1,2),y(1,2),'g.','markersize',msize );
xlim(xlimits);
ylim(ylimits);
grid on;
xlabel('x /AU','fontsize',fsize);
ylabel('y /AU','fontsize',fsize);
title('Gravity simulator using Verlet method','fontsize',fsize);
set(gca,'fontsize',fsize)
axis manual
stop=0;
while stop == 0
    for n=2:N
        set( p, 'xdata', x(n,3:end).', 'ydata', y(n,3:end).' );
        set( p1, 'xdata', x(n,1), 'ydata', y(n,1) );
        set( p2, 'xdata', x(n,2), 'ydata', y(n,2) );
        drawnow
        pause(1/100);
    end
end